
close all % close all plots
%
% Plot the Chi distribution.
%
figure(1)
set(gca,'fontsize',12)
hold on

r = [0:.01:4];

% Plot Chi the distribution
text1= ['d=1.1'];
d = 1.1;
M1 = (sqrt(2)*gamma((1 + d)/2))/gamma(d/2);
s = 1/M1;
y = PDFChi(r,[s,d]);
I1 = sum(y)*.01;
plot(r,y,'-.r');

% Plot Chi the distribution
text2= ['d=1.5'];
d = 1.5;
M1 = (sqrt(2)*gamma((1 + d)/2))/gamma(d/2);
s = 1/M1;
y = PDFChi(r,[s,d]);
I2 = sum(y)*.01;
plot(r,y,'--g');

% Plot Chi the distribution
text3= ['d=1.8'];
d = 1.8;
M1 = (sqrt(2)*gamma((1 + d)/2))/gamma(d/2);
s = 1/M1;
y = PDFChi(r,[s,d]);
I3 = sum(y)*.01;
plot(r,y,':b');

% Plot Chi the distribution
text4= ['d=2.0'];
d = 2;
M1 = (sqrt(2)*gamma((1 + d)/2))/gamma(d/2);
s = 1/M1;
y = PDFChi(r,[s,d]);
I4 = sum(y)*.01;
plot(r,y,'-k');

AreasChi = [I1, I2, I2,I4];

xlabel('r');
ylabel('p');
legend(text1,text2,text3,text4)
title('Chi PDF')
hold off
print('-dpsc2', 'figures/PDF-Chi.eps')


% Plot the Frechet distribution.
figure(2)
hold on

r = [0:.01:3];

% Plot the simple Weibull distribution.
k = 2;
text1 = 'Simple Weibull';
lambda = 1/gamma(1+1/k); % For M_1 = 1
y = PDFWeibull(r,[lambda,k]);
plot(r,y,'-k');

% Plot the Frechet Distribution.
a = 1.4;
text2 = '\alpha=1.4';
s = 1/gamma(1-1/a); % For M_1 = 1
y = PDFFrechet(r,[s,a]);
plot(r,y,'-.r');

a = 1.6;
text3 = '\alpha=1.6';
s = 1/gamma(1-1/a); % For M_1 = 1
y = PDFFrechet(r,[s,a]);
plot(r,y,'--g');

a = 2;
text4 = '\alpha=2.0';
s = 1/gamma(1-1/a); % For M_1 = 1
y = PDFFrechet(r,[s,a]);
plot(r,y,':b');

xlabel('r');
ylabel('p');
legend(text1,text2,text3,text4)
title('Frechet PDF')
hold off
print('-dpsc2', 'figures/PDF-Frechet.eps')

% Plot the long-short distribution.

figure(3)
hold on
r = [0:.01:4];

% Plot the simple Weibull distribution.
k = 2;
text1 = 'Simple Weibull';
lambda = 1/gamma(1+1/k); % For M_1 = 1
y = PDFWeibull(r,[lambda,k]);
plot(r,y,'-k');

% Plot the long-short distribution.
a = 1+1/2;
b = 2;
test1 = a*(b-1)-1;
text2 = 'a=3/2, b=2';
s = (a*gamma(b))/((b-1)*gamma(1/a)*gamma(b-(1/a)-1));
y = PDFLS(r,[s,a,b]);
plot(r,y,'--r');

% Plot the long-short distribution.
a = 1+1;
b = 2;
test2 = a*(b-1)-1;
text3 = 'a=2, b=2';
s = (a*gamma(b))/((b-1)*gamma(1/a)*gamma(b-(1/a)-1));
y = PDFLS(r,[s,a,b]);
plot(r,y,'-.g');

% Plot the long-short distribution.
a = 1+2;
b = 2;
test3 = a*(b-1)-1;
text4 = 'a=3, b=2';
s = (a*gamma(b))/((b-1)*gamma(1/a)*gamma(b-(1/a)-1));
y = PDFLS(r,[s,a,b]);
plot(r,y,':r');

test = [test1,test2,test3];

xlabel('r');
ylabel('p');
legend(text1,text2,text3,text4)
title('Long-Short PDF')

hold off
print('-dpsc2', 'figures/PDF-LS.eps')

% Plot the generalized Weibull Distribution.
figure(4)
hold on
r = [0:.01:5];

k = 2;
lambda = k/gamma(1/k); % For M_1 = 1
y = PDFWeibull(r,[lambda,k]);
I1 = sum(y)*.01;
plot(r,y,'-k');

k = 3/2;
lambda = k/gamma(1/k); % For M_1 = 1
y = PDFWeibull(r,[lambda,k]);
I2 = sum(y)*.01;
plot(r,y,'--r');

k = 1.1;
lambda = k/gamma(1/k); % For M_1 = 1
y = PDFWeibull(r,[lambda,k]);
I3 = sum(y)*.01;
plot(r,y,'-.g');

AreasWeibull = [I1, I2, I3];

xlabel('r');
ylabel('p');
legend('k=2.0','k=1.5','k=1.1')
title('Generalized Weibul PDF')
hold off
print('-dpsc2', 'figures/PDF-GW.eps')

% Plot the GEV distribution.
figure(5)
hold on

r = [0:.01:3];

% Plot the simple Weibull distribution.
k = 2;
text1 = 'Simple Weibull';
lambda = 1/gamma(1+1/k); % For M_1 = 1
y = PDFWeibull(r,[lambda,k]);
plot(r,y,'-k');

% Plot the GEV Distribution.
text2 = '\xi=1/4';
xi = 1/4;
mu = 80/128;
M1 = (gamma(1-xi) -1)/xi;
sigma = (1-mu)/M1;
y = PDFGEV(r,[sigma,xi,mu]);
plot(r,y,'-.r');
zero = PDFGEV(0,[sigma,xi,mu])

% Plot the GEV Distribution.
text3 = '\xi=1/8';
xi = 1/8;
mu = 89/128;
M1 = (gamma(1-xi) -1)/xi;
sigma = (1-mu)/M1;
y = PDFGEV(r,[sigma,xi,mu]);
plot(r,y,'--g');
zero = PDFGEV(0,[sigma,xi,mu])

% Plot the GEV Distribution.
text4 = '\xi=1/16';
xi = 1/16;
mu = 93/128;
M1 = (gamma(1-xi) -1)/xi;
sigma = (1-mu)/M1;
y = PDFGEV(r,[sigma,xi,mu]);
plot(r,y,':b');
zero = PDFGEV(0,[sigma,xi,mu])

xlabel('r');
ylabel('p');
legend(text1,text2,text3,text4)
title('GEV PDF')
hold off
print('-dpsc2', 'figures/PDF-GEV.eps')
